@extends('admin.layout.page-app')
@section('page_title', __('label.quiz_configuration'))
@section('tab_title', __('label.quiz_configuration'))

@section('content')
    @include('admin.layout.sidebar')

    <div class="right-content">
        @include('admin.layout.header')

        <div class="body-content">

            <!-- mobile title -->
            <h1 class="page-title-sm">{{__('label.quiz_configuration')}}</h1>

            <div class="border-bottom row mb-3">
                <div class="col-sm-12">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="{{ route('admin.dashboard') }}">{{__('label.dashboard')}}</a></li>
                        <li class="breadcrumb-item active" aria-current="page">{{__('label.quiz_configuration')}}</li>
                    </ol>
                </div>
            </div>

            <div class="row">
                @foreach($data as $index => $quiz)
                    <div class="col-4">
                        <div class="card custom-border-card">
                            <h5 class="card-header d-flex align-items-center justify-content-between pb-2">
                                <span class="d-flex align-items-center">
                                    <i class="fa-solid {{ $quiz['icon'] }} fa-2x mr-3 primary-color"></i>
                                    <span class="primary-color fw-semibold">{{ $quiz['name'] }}</span>
                                </span>
                            </h5>
                            <div class="card-body">
                                <h6>{{ $quiz['description'] }}</h6>
                                <div class="d-flex justify-content-between mt-3">
                                    @if($quiz['quiz_status'] == 1)
                                        <button type="button" id="status_btn_{{ $quiz['id'] }}" onclick="change_status({{ $quiz['id'] }})" class="show-btn">
                                            {{__('label.show')}}
                                        </button>
                                    @else
                                        <button type="button" id="status_btn_{{ $quiz['id'] }}" onclick="change_status({{ $quiz['id'] }})" class="hide-btn">
                                            {{__('label.hide')}}
                                        </button>
                                    @endif

                                    @if($quiz['id'] != 7 && $quiz['id'] != 8 && $quiz['id'] != 12)
                                        <a href="{{ route('admin.quizconfiguration.edit', $quiz['id']) }}" class="btn-default mw-120 mr-2">{{__('label.configure_quiz')}}</a>
                                    @endif
                                </div>
                            </div>
                        </div>
                    </div>                            
                @endforeach
            </div>
        </div>
    </div>
@endsection

@section('pagescript')
    <script>
        function change_status(id) {

            var Demo_Mode = '<?php echo Demo_Mode(); ?>';
            if(Demo_Mode == 1){

                $("#dvloader").show();
                var url = `{{ route('admin.quizconfiguration.show', '') }}/${id}`;

                $.ajax({
                    type: "GET",
                    url: url,
                    headers: {
                        'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                    },
                    success: function(resp) {
                        $("#dvloader").hide();

                        if (resp.status == 200) {
                            if (resp.status_code == 1) {
                                $('#status_btn_' + id).text('{{__("label.show")}}').removeClass('hide-btn').addClass('show-btn');
                            } else {
                                $('#status_btn_' + id).text('{{__("label.hide")}}').removeClass('show-btn').addClass('hide-btn');
                            }
                            toastr.success(resp.success);
                        } else {
                            toastr.error(resp.errors);
                        }
                    },
                    error: function(XMLHttpRequest, textStatus, errorThrown) {
                        $("#dvloader").hide();
                        toastr.error(errorThrown, textStatus);
                    }
                });
            } else {
                showError();
            }
        };
    </script>
@endsection